@extends('layouts/layoutMaster')
@section('style')
@section('title', 'General Settings')

@section('vendor-style')
@vite([
'resources/assets/vendor/libs/select2/select2.scss',
])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite([
'resources/assets/vendor/libs/select2/select2.js',
])
@endsection

@section('content')

<!-- Users List Table -->
<div class="card">
    <div class="card-header border-bottom pb-1">
        <h5 class="card-title mb-1 text-black">General Settings</h5>
        <nav aria-label="breadcrumb" class="mb-2">
            <ol class="breadcrumb custom-breadcrumb">
                <!-- Home -->
                <li class="breadcrumb-item">
                    <a href="{{ url('/dashboard') }}">
                        <i class="mdi mdi-home"></i> Home
                    </a>
                </li>

                <!-- Active Page -->
                <li class="breadcrumb-item active" aria-current="page">
                    <a href="javascript:void(0);" class="active-link">
                        <i class="mdi mdi-cog"></i> Settings
                    </a>
                </li>
            </ol>
        </nav>
    </div>
    <div class="card-body">
        <form id="validationForm" class="needs-validation" novalidate  enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-lg-6">
                    <div class="row">
                        <label class="col-lg-6 text-dark fs-6 fw-semibold">Logo<span
                                class="text-danger">*</span></label>
                        <div class="col-lg-6">
                            <div class="align-items-sm-center gap-4">
                                <img src="{{asset('assets/common/logo_small.png')}}" alt="user-avatar"
                                    class="d-block w-px-120 h-px-120 rounded border border-gray-600 border-solid"
                                    id="uploadedlogo" />


                                <div class="button-wrapper">
                                    <div class="d-flex align-items-start mt-2 mb-2">
                                        <label for="upload" class="btn btn-sm btn-primary me-2" tabindex="0"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Upload Logo">
                                            <i class="mdi mdi-tray-arrow-up"></i>
                                            <input type="file" name="logo" id="upload" class="file-in" hidden
                                                accept="image/png, image/jpeg" />
                                        </label>

                                        <button type="button" class="btn btn-sm btn-outline-danger file-reset"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Reset Logo">
                                            <i class="mdi mdi-reload"></i>
                                        </button>
                                    </div>
                                    <div class="small">Allowed JPG, PNG. Max size of 800K</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="row">
                        <label class="col-lg-6 text-dark fs-6 fw-semibold">Fav Icon<span
                                class="text-danger">*</span></label>
                        <div class="col-lg-6">
                            <div class="align-items-sm-center gap-4">
                                <img src="{{asset('assets/common/logo_small.png')}}" alt="Fav Icon"
                                    class="d-block w-px-120 h-px-120 rounded border border-gray-600 border-solid"
                                    id="fav_uploadedlogo" />
                                <div class="button-wrapper">
                                    <div class="d-flex align-items-start mt-2 mb-2">
                                        <label for="fav_upload" class="btn btn-sm btn-primary me-2" tabindex="0"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Upload Fav Icon">
                                            <i class="mdi mdi-tray-arrow-up"></i>
                                            <input type="file" name="fav_icon" id="fav_upload" class="fav_file-in"
                                                hidden accept="image/png, image/jpeg" />
                                        </label>
                                        <button type="button" class="btn btn-sm btn-outline-danger fav_file-reset"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Reset Fav Icon">
                                            <i class="mdi mdi-reload"></i>
                                        </button>
                                    </div>
                                    <div class="small">Allowed JPG, PNG. Max size of 800K</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4 mb-2">
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-2 fs-6 fw-semibold">Title<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title"
                        value="Elysium Groups" required />
                    <div class="invalid-feedback">Please enter the Title.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Website<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="website" name="website" placeholder="Enter Website (URL)"
                        value="https://elysiumgroups.com/" required />
                    <div class="invalid-feedback">Please enter the Website (URL).</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Email ID<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="emailid" name="email_id" placeholder="Enter Email ID"
                        value="info@elysiumgroups.com" required />
                    <div class="invalid-feedback">Please enter the Email ID.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Phone No<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="phoneno" name="phone_number"
                        placeholder="Enter Phone No" value="0452 439 0702" required />
                    <div class="invalid-feedback">Please enter the Phone No.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Mobile No<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="mobileno" name="mobile_number"
                        placeholder="Enter Mobile No" value="0452 439 0702" required />
                    <div class="invalid-feedback">Please enter the Mobile No.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Whatsapp No<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="whatsappno" name="whatsapp_number"
                        placeholder="Enter Whatsapp No" value="" required />
                    <div class="invalid-feedback">Please enter the Whatsapp No.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Date Format<span class="text-danger">*</span></label>
                    <select id="date_format" class="select3 form-select selectpicker w-100" data-style="btn-default"
                        name="date_format" data-live-search="true">
                        <option value="">Select Date Format</option>
                        <option value="d-m-Y" >dd-mm-yyyy</option>
                        <option value="Y-m-d" >yyyy-mm-dd</option>
                        <option value="Y/m/d">yyyy/mm/dd</option>
                        <option value="d-M-Y" selected>dd-mmm-yyyy</option>
                        <option value="d/M/Y">dd/mmm/yyyy</option>
                    </select>
                </div>

                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Registered Name</label>
                    <input type="text" class="form-control" id="registered_name" name="registered_name"
                        placeholder="Enter Registered Name" value="Elysium Group of Companies" required />
                    <div class="invalid-feedback">Please enter the Registered Name.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Tax No</label>
                    <input type="text" class="form-control" id="" name="tax_no" placeholder="Enter Tax No"
                        value="22AAAAA0000A1Z5" required />
                    <div class="invalid-feedback">Please enter the Tax No.</div>
                </div>

                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Country<span class="text-danger">*</span></label>
                    <select id="countryId" name="country" class="select3 form-select">
                        <option value="">Select Country</option>
                        <option value="1" selected>India</option>
                        <option value="2" >USA</option>
                        <option value="3">UAE</option>
                        <option value="4" >South Africa</option>
                    </select>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">State<span class="text-danger">*</span></label>
                    <select id="stateId" name="state" class="select3 form-select">
                        <option value="">Select State</option>
                        <option value="1" selected>Tamil Nadu</option>
                        <option value="2" >Kerala</option>
                        <option value="3">Karnataka</option>
                        <option value="4" >Andhra Pradesh</option>
                    </select>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">City<span class="text-danger">*</span></label>
                    <select id="cityId" name="city" class="select3 form-select">
                        <option value="">Select City</option>
                        <option value="1" selected>Madurai</option>
                        <option value="2" >Chennai</option>
                        <option value="3">Coimbatore</option>
                        <option value="4" >Trichy</option>
                    </select>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Area / Street<span
                            class="text-danger">*</span></label>
                    <textarea class="form-control" rows="2" id="" name="address"
                        placeholder="Enter Area / Street">230, Church Rd, Anna Nagar, Sathamangalam, Madurai</textarea>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Pincode<span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="" name="pincode" placeholder="Enter Pincode"
                        value="625020" required />
                    <div class="invalid-feedback">Please enter the Pincode.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Payment Remainder Days<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="" name="pay_rem_day" maxlength="1"
                        placeholder="Enter Payment Remainder Days" value="10"
                        oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"
                        required />
                    <div class="invalid-feedback">Payment Remainder Days Required.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Currency Format<span
                            class="text-danger">*</span></label>
                    <select id="currency_format" class="select3 form-select selectpicker w-100" data-style="btn-default"
                            name="currency_format" data-live-search="true">
                            <option value="">Select Currency Format</option>
                            <option value="1" selected>IND - ₹</option>
                            <option value="2" >USD - $</option>
                            <option value="3">Euro - €</option>
                    </select>
                    <div class="invalid-feedback">Currency format Required.</div>
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Twitter</label>
                    <input type="text" class="form-control" id="twitter" name="twitter" placeholder="Enter Twitter"
                        value="https://twitter.com/elysiumgroups" />
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Pinterest</label>
                    <input type="text" class="form-control" id="pinterest" name="pinterest"
                        placeholder="Enter Pinterest" value="https://in.pinterest.com/elysiumgroups/" />
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">LinkedIn</label>
                    <input type="text" class="form-control" id="linkedin" name="linkedin" placeholder="Enter LinkedIn"
                        value="https://www.linkedin.com/company/elysium-group-of-companies" />
                </div>
                <div class="col-lg-4 mb-3">
                    <label class="text-dark mb-1 fs-6 fw-semibold">Youtube</label>
                    <input type="text" class="form-control" id="youtube" name="youtube" placeholder="Enter Youtube"
                        value="https://www.youtube.com/channel/UCP3Rm-1d-SZDLjQPoKvcOCQ" />
                </div>
            </div>
            <div class="d-flex justify-content-end align-items-center mt-4">
                {{-- <button type="reset" class="btn btn-outline-secondary me-2">Cancel</button> --}}
               
                <a href="{{url('/settings/general_settings')}}" class="btn btn-outline-secondary me-2">Cancel</a>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
        </form>
    </div>
</div>
<!-- Logo File Upload Start -->
<!-- jQuery from CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Toastr CSS from CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- Toastr JavaScript from CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<style>
    /* Customize Toastr notification */
    .toast-success {
        background-color: green;
    }

    /* Customize Toastr notification */
    .toast-error {
        background-color: red;
    }
</style>
<script>
    const form = document.getElementById('validationForm');
const emailInput = document.getElementById('emailid');
const phoneInput = document.getElementById('phoneno');
const mobileInput = document.getElementById('mobileno');
const whatsappInput = document.getElementById('whatsappno');

emailInput.addEventListener('input', function(event) {
    if (!validateEmail(emailInput.value)) {
        displayError(emailInput, "Please enter a valid email address.");
    } else {
        clearError(emailInput);
    }
});

phoneInput.addEventListener('input', function(event) {
    if (!validatePhoneNumber(phoneInput.value)) {
        displayError(phoneInput, "Please enter a 10-digit phone number.");
    } else {
        clearError(phoneInput);
    }
});

form.addEventListener('submit', function(event) {
    event.preventDefault();

    if (!form.checkValidity() || !validateEmail(emailInput.value)) {
        displayError(emailInput, "Please enter a valid email address.");
        event.stopPropagation();
    } else if (!validatePhoneNumber(phoneInput.value)) {
        displayError(phoneInput, "Please enter a 10-digit phone number.");
        event.stopPropagation();
    } else {
        form.submit();
        toastr.success('General Setting updated successfully!');
    }

    form.classList.add('was-validated');
});

function validateEmail(email) {
    const emailRegex =
        /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return emailRegex.test(email);
}

function validatePhoneNumber(phoneNumber) {
    // Remove non-numeric characters from phone number
    const numericPhoneNumber = phoneNumber.replace(/\D/g, '');
    return numericPhoneNumber.length === 10; // Assuming you want exactly 10 digits
}

function displayError(input, message) {
    const feedbackElement = input.nextElementSibling;
    feedbackElement.innerText = message;
    input.classList.add('is-invalid');
}

function clearError(input) {
    const feedbackElement = input.nextElementSibling;
    feedbackElement.innerText = "";
    input.classList.remove('is-invalid');
}
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    const logoFileInput = document.querySelector('.file-in');
    const logoResetButton = document.querySelector('.file-reset');
    const faviconFileInput = document.querySelector('.fav_file-in');
    const faviconResetButton = document.querySelector('.fav_file-reset');

    // Function to reset logo image and input
    logoResetButton.addEventListener('click', function() {
        const logoImage = document.getElementById('uploadedlogo');
        const resetLogoImage = ""; // Replace with the initial logo path
        logoImage.src = resetLogoImage;
        logoFileInput.value = null;
    });

    // Function to reset favicon image and input
    faviconResetButton.addEventListener('click', function() {
        const faviconImage = document.getElementById('fav_uploadedlogo');
        const resetFaviconImage =
            "{{ asset('assets/common/logo_small.png') }}"; // Replace with the initial favicon path
        faviconImage.src = resetFaviconImage;
        faviconFileInput.value = null;
    });

    // Function to preview logo image
    logoFileInput.addEventListener('change', function() {
        const logoImage = document.getElementById('uploadedlogo');
        if (this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                logoImage.src = e.target.result;
            };
            reader.readAsDataURL(this.files[0]);
        }
    });

    // Function to preview favicon image
    faviconFileInput.addEventListener('change', function() {
        const faviconImage = document.getElementById('fav_uploadedlogo');
        if (this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                faviconImage.src = e.target.result;
            };
            reader.readAsDataURL(this.files[0]);
        }
    });
});
</script>
@endsection